%  Please do not remove the following comments when disseminating the program
%  Please consider to cite our paper if you use the program:
%  Wei E.I. Sha, Xingang Ren, Luzhou Chen, and Wallace C.H. Choy, 
% The Efficiency Limit of CH3NH3PbI3 Perovskite Solar Cells, 
%  AIP, Applied Physics Letters, vol. 106, no. 22, pp. 221104, Jun. 2015.

%  The program was written by Wei E.I. Sha
%  Email: wsha@eee.hku.hk  dr.weisha@gmail.com

clc;clear

L=500; % active layer thickness (nm)

%  J-V curve
V=0:0.01:1.05; %  voltage
for m=1:length(V)
    J(m)=limit_solar(L,V(m),10000);  %  10000 nm for angular cuoff_wavelength1 (no restriction)
end

%  postprocessing
Jsc_ref=J(1)                 %  Jsc (A/m^2)
JJ=abs(J);
[a,b]=min(JJ);
Voc_ref=V(b)                 %  Voc (V)
PCE_ref=max(-V.*J)/1000      %  PCE 
FF_ref=PCE_ref*1000/(-Jsc_ref)/Voc_ref  % Fill factor

plot(V,J/10)  % J-V curve
xlabel('Voltage (V)')
ylabel('Current Density (mA/cm^2)')


